# 鱼皮的 AI 指南 - 4、AI 编程技术

> ⭐️ 推荐观看视频版：[https://www.bilibili.com/video/BV1i9Z8YhEja](https://www.bilibili.com/video/BV1i9Z8YhEja/)



最后这部分最重要，作为程序员，咱们不光要会用 AI 工具、能利用 AI 开发项目，还要能够自主开发 AI 项目，把 AI 的能力接入到自己的项目中。

有句话说得好：**AI 时代，所有的传统业务都值得利用 AI 重塑一遍。**

所以现在很多公司都在招能够开发 AI 项目的程序员，这也是我们的机会。那么我们要学习哪些知识和技术，才能成为企业招聘的香饽饽呢？

### 1、AI 开发框架

首先从技术角度出发，我们要学习主流的 AI 开发框架，比如 Spring AI、LangChain4j 和 LangGraph。

[Spring AI](https://docs.spring.io/spring-ai/reference/getting-started.html) 和 [LangChain4j](https://docs.langchain4j.dev/intro) 的作用是类似的，都提供了很多现成的方法来帮我们提高开发 AI 应用的效率。比如快速对接大模型、保存会话上下文、对接向量数据库实现 RAG 等等。

![](https://pic.yupi.icu/1/1743563460857-95800757-867c-4e8a-ba7c-dd490d09fcbd.png)

区别是 Spring AI 更容易和主流 Java 开发框架 Spring 集成，上手难度较低；而 LangChain4j 更灵活，更适合开发复杂的智能体。比如在开发一个智能文档分析系统时，利用 LangChain4j，智能体能够自动读取文档内容，调用搜索引擎获取相关背景知识，然后根据任务需求，将文档信息与外部知识结合，生成分析报告。

不过我的建议是，二个都要学，先从 Spring AI 学起，再学 LangChain4j 会更简单。

[LangGraph](https://www.langchain.com/langgraph) 框架会更复杂一些，它用图的结构来组织和管理 AI 相关的工作流，适合构建有状态、多代理的企业级 AI 大项目。打个比方，我们有多个 AI 智能体，分别负责生成文字、生成图片、组合文字和图片，那么 LangGraph 像是负责人，可以安排这些智能体的工作顺序，一起搞大事。

![](https://pic.yupi.icu/1/1743563530213-250ec646-6247-4b8a-9c5f-f6f642a9652c.png)

用一个表格来总结这几种技术：

| 场景          | 推荐框架    | 优势                 |
| ------------- | ----------- | -------------------- |
| Java 企业应用 | Spring AI   | 无缝集成 Spring 生态 |
| 智能体开发    | LangChain4j | 完整 Agent 工具链    |
| 复杂工作流    | LangGraph   | 可视化编排           |

### 2、AI 集成

开发 AI 应用的前提是要有大模型，但是大模型要消耗算力才能运行，算力就是金钱，从哪儿搞来大模型呢？

2 种方法，使用 AI 云服务、或者本地部署大模型。

#### AI 云服务

AI 云服务就是其他企业为我们部署了 AI 大模型，通过 API 接口的方式提供给我们使用，按量计费。

比如阿里云百炼、火山引擎、硅基流动、Open AI 等等。

![](https://pic.yupi.icu/1/1743563631799-46ff94d5-d51b-4dc5-b6cf-dec28bdcdb39.png)

咱们程序员需要重点掌握的是：

1. 如何通过 API 接入云服务？
2. 如何使用 AI 云服务来创建智能体和配置参数？
3. 如何选择合适的云服务？这就需要关注各家云服务的计费模式和服务质量
4. 如何更低成本、更稳定地使用云服务？这就需要我们学习 Prompt 工程和高可用技术



#### 本地部署大模型

本地部署大模型对于很多企业来说也是刚需，数据无需上传至云端，能够有效保障数据的安全性和隐私性，尤其适用于医疗、金融等对数据安全极为敏感的行业。

本地部署大模型其实并不难，只需要使用 [Ollama 工具](https://ollama.com/) 就可以一键部署各种主流的开源模型。

![](https://pic.yupi.icu/1/1743563719547-bbed1c54-d1f1-496f-afc2-d755c3538732.png)

唉，但部署大模型的难度不在于技术啊，主要是没算力啊！不然我也给我们团队的 [编程导航](https://codefather.cn/) 和 [面试鸭](https://www.mianshiya.com) 都来一套鱼皮大模型了。



### 3、AI 领域业务

企业中的 AI 业务开发，可不仅仅是来个 AI 对话就够了，咱们还要掌握几种更复杂的业务开发，比如 RAG 知识库、多模态、MCP 服务、ReAct 智能体。

#### RAG 知识库

很多公司都有属于自己的业务知识和文档，会构建自己的问答系统或客服，这就要用到 RAG 检索增强生成技术。先通过文本嵌入模型，将企业各种文档转化为向量，存入向量数据库；当用户提问时，系统在向量数据库检索相关向量数据，找到最相似文档片段，和问题一起输入大模型处理。这样一来，大模型能够基于企业真实数据作答，更准确贴合实际。

![](https://pic.yupi.icu/1/1743563751814-4123230c-c4b8-458f-bf8b-070c7550dd54.png)

关于 RAG 能学的知识可太多了，比如主流的向量数据库 Milvus 和 PGVector、文档的抽取 / 转换 / 加载、索引的构建、查询策略的优化等等。**这也是 AI 企业面试的重点！**

#### 多模态

多模态也是主流的 AI 业务场景，即融合文本、图像、音频、视频等多种不同类型的数据模态，从而提高产品使用的易用性，做出更多有创意的功能。

比如做个智能导购系统，顾客既可以输入文字描述想要的商品，系统也能识别顾客上传的商品图片，甚至可以理解顾客通过语音提出的购物需求。系统会将这些来自不同模态的数据进行整合处理，在商品数据库中精准匹配符合要求的商品，并将结果反馈给顾客。

![](https://pic.yupi.icu/1/1743563981663-8c9f4746-03dc-4b32-8477-ba9a9042922c.png)

想开发多模态应用，咱们要学习模态转换技术，比如文本转语音（TTS）、语音转文本（STT）、光学字符识别（OCR）等，不过这些都有现成的工具库或者云服务，掌握调用方法就行。还可以通过 Spring AI、LangChain 等 AI 开发框架调用不同模态的大模型，降低开发难度。

![](https://pic.yupi.icu/1/1743563810137-00b86ee7-2e01-44fd-9c1d-8f4198ef59ee.png)

#### MCP 服务

MCP（Model Context Protocol，模型上下文协议）可以理解为提供给 AI 的各种服务，AI 利用这些服务能够实现更强大的功能。

![](https://pic.yupi.icu/1/1743563832927-7a2df71f-acc1-47c4-9135-e7d888749dbc.png)

如何在项目中接入别人的 MCP 服务，来增强自己的项目能力；以及如何开发自己的 MCP 服务，让别人的项目使用，都是必须要学习的。现在使用 Spring AI 等开发框架就可以开发 MCP 服务，而且甚至有高手做了个 [网站](http://mcpify.ai/)，能够一句话创建自己的 MCP 服务，这真的是泰裤辣。

![](https://pic.yupi.icu/1/1743563865750-bbd02b74-2a56-49a9-963f-e633c1484fe5.png)

#### ReAct 智能体

ReAct 是一种构建智能体的开发范式，目的是打造能够依据推理结果自主采取行动的智能体。

它的开发过程会涉及到任务规划、工具调用、交互 I/O、异常处理等知识。尤其是工具调用，可以通过 Function Call 或 MCP 实现像天气查询、文件读写、网页运行、信息检索、终端命令执行等功能。

![](https://pic.yupi.icu/1/1743563922663-0096045d-8a99-4202-b30d-df77a341e697.png)

就拿开发视频网站为例，用户说了 “帮我开发一个 Dilidili 视频网站并部署上线” 的指令时，智能体首先会深入理解任务内容，通过推理梳理出一系列执行步骤，包括明确需求、设计方案、搭建框架、生成代码、部署上线等。接下来，智能体就会调用相应的工具来执行这些行动。如果执行过程中遇到问题，还会询问我们的意见，重新推理并及时调整行动方案。

![](https://pic.yupi.icu/1/1743564028474-638e6414-9a22-4350-80f3-7bf174dd0f77.png)

### 4、AI 工具链

最后就是我们开发 AI 项目时可能会用到的一些平台、工具和类库了。

#### 低代码平台

比如主流的低代码 AI 开发平台 [Dify](https://dify.ai/)，可以让我们通过拖拉拽的方式构建自己的 AI 智能体，创建知识库并导入自己的文档，搭建复杂的工作流等等。就哪怕你不会写代码，都能用它搞出复杂的 AI 应用。

![](https://pic.yupi.icu/1/1743564064922-03f6365b-a712-47d9-be55-4867b848a269.png)

#### 工具库

还有一些开发 AI 智能体时会用到的工具库，比如：

- Apache Tika，功能强大的文件解析器工具库，支持解析 PDF、Word、Excel、PowerPoint 等各种文档，然后提供给 AI 作为知识。
- Playwright，用于模拟浏览器行为的工具库，AI 需要运行网页、抓取网页数据、自动化测试时，它都能派上用场。
- JSON 格式解析库 GSON 和 Kryo
- HTML 文档解析库 jsoup

这些类库基本没什么学习成本，要用的时候看文档就好了。

#### 部署工具

项目最终是要部署上线的嘛，所以我们还要掌握高效的部署工具，让 AI 应用从开发环境顺利过渡到生产环境，为用户提供稳定服务。

如果不在意价格、追求稳定的话，还是优先选择大厂提供的云服务来部署项目。但如果是个人学习使用、想快速上线自己的 AI 小应用，可以试试下面这些平台：

- [Vercel](https://vercel.com/)：适合前端应用的部署平台，支持自动构建、在线浏览、CDN 分发，而且还免费提供可访问的域名
- [Sealos](https://sealos.io/)：云原生应用管理平台，支持 Kubernetes 集群管理，为 AI 应用提供容器化部署环境，适合需要弹性伸缩的 AI 服务
- [Railway](https://railway.com/)：能让开发人员轻松部署 Docker 容器，无需操心服务器配置与运维，且自带自动化构建工具、环境管理能力等

当然，想快速部署服务，上面提到的 Docker 容器化技术也是必须要学习的，就像 APP 的安装包一样，能够轻松分发和部署你的应用程序。

![](https://pic.yupi.icu/1/1743564338228-ffc55f7b-7bcd-40df-a10b-4accfb666379.png)

其实我有一种假设，如果 AI 足够稳定、并且一句提示词就能生成完整应用的话，是不是可以直接根据 Prompt 来部署项目啊。扯远了扯远了，当我没说吧~

------

怎么样，要学的东西还是挺多的吧，有没有感觉信息量爆炸。别担心，上面这些都是实践，咱还得学一些理论呀，比如某个框架的底层原理、调优技巧、算法实现等等。不过真的别担心，我也在持续学习这些内容并且会持续分享给大家，以上我提到的东西，在我后续的 [项目教程](https://www.codefather.cn/course) 中，都会讲到，期待的话可以关注一下。



## 尾声

OK，以上就是鱼皮 AI 指南的内容，我觉得能有 1% 的同学看完就不错了。

如果你问我 AI 会淘汰程序员么？我的答案仍然是 “会”。因为程序员本身就是需要持续学习和实践来保持竞争力的，只要大家能够学会我提到的这些知识，[多关注 AI 的前沿资讯](https://github.com/liyupi/ai-guide)，相信 AI 不会抢走咱们程序员的饭碗，而是成为咱们改造世界的杠杆。

在这里也推荐一下我们免费公开的 `AI 知识库`，汇总收集了最新最全的 DeepSeek 知识，帮助大家更好地适应 AI 时代的到来。

鱼皮的 AI 知识库：[https://ai.codefather.cn](https://ai.codefather.cn/)

里面除了各种教程资料外，也重点给大家分享了很多 AI 工具的具体应用场景，比如接入办公软件提升效率，帮你做自媒体，AI 批量制作视频等。希望帮助大家举一反三，找到新的思路。